using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SMAT_CE
{
    public partial class uc_ModelDataD : ucBase
    {
        public uc_ModelDataD()
        {
            InitializeComponent();

            #region Language added by Edwin
            if (LanguageOld.CurrentLanguage() == "Ch")
            {
                //Language.GetLanguagePath();
                Dictionary<string, string> dic = new Dictionary<string, string>();
                LanguageOld.SetDicFromXml(this, dic);
                LanguageOld.ChangeLanguage(dic, this);
            }
            #endregion
        }

        private void uc_ModelDataD_Load(object sender, EventArgs e)
        {
            try
            {
                cboGridPointModelOptionDaily.Items.Add("1x1");
                cboGridPointModelOptionDaily.Items.Add("3x3");
                cboGridPointModelOptionDaily.Items.Add("5x5");
                cboGridPointModelOptionDaily.Items.Add("7x7");

                choGridforSpatialForecast.Items.Add("1x1");
                choGridforSpatialForecast.Items.Add("3x3");
                choGridforSpatialForecast.Items.Add("5x5");
                choGridforSpatialForecast.Items.Add("7x7");

                cboStatisticMethodDaily.Items.Add("Mean");
                cboStatisticMethodDaily.Items.Add("Maximum");
                cboStatisticMethodDaily.Items.Add("Maximum-paired in space");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }

        }

        private void lblTemporalAdjustment_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_2_7_model_data_options.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }

        private void lblAdvancedOptions_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                Help.ShowHelp(this, Application.StartupPath + @"\Data\User Manual.chm", "2_2_7_model_data_options.htm");
            }
            catch (Exception ex)
            {
                CommonClass.LogError(ex);
            }
        }
    }
}
